/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;
import org.openide.util.Parameters;

public final class NetworkSettings {
    private static final String PROXY_AUTHENTICATION_USERNAME = "proxyAuthenticationUsername";
    private static final String PROXY_AUTHENTICATION_PASSWORD = "proxyAuthenticationPassword";
    private static final String USE_PROXY_AUTHENTICATION = "useProxyAuthentication";
    private static final Logger LOGGER = Logger.getLogger(NetworkSettings.class.getName());

    public static String getProxyHost(URI u) {
        if (NetworkSettings.getPreferences() == null) {
            return null;
        }
        InetSocketAddress sa = NetworkSettings.analyzeProxy(u);
        return sa == null ? null : sa.getHostName();
    }

    public static String getProxyPort(URI u) {
        if (NetworkSettings.getPreferences() == null) {
            return null;
        }
        InetSocketAddress sa = NetworkSettings.analyzeProxy(u);
        return sa == null ? null : Integer.toString(sa.getPort());
    }

    public static String getAuthenticationUsername(URI u) {
        if (NetworkSettings.getPreferences() == null) {
            return null;
        }
        if (NetworkSettings.getPreferences().getBoolean(USE_PROXY_AUTHENTICATION, false)) {
            return NetworkSettings.getPreferences().get(PROXY_AUTHENTICATION_USERNAME, "");
        }
        return null;
    }

    public static String getKeyForAuthenticationPassword(URI u) {
        if (NetworkSettings.getPreferences() == null) {
            return null;
        }
        if (NetworkSettings.getPreferences().getBoolean(USE_PROXY_AUTHENTICATION, false)) {
            return PROXY_AUTHENTICATION_PASSWORD;
        }
        return null;
    }

    private static Preferences getPreferences() {
        return NbPreferences.root().node("org/netbeans/core");
    }

    private static InetSocketAddress analyzeProxy(URI uri) {
        Parameters.notNull("uri", uri);
        List<Proxy> proxies = ProxySelector.getDefault().select(uri);
        assert (proxies != null) : "ProxySelector cannot return null for " + uri;
        assert (!proxies.isEmpty()) : "ProxySelector cannot return empty list for " + uri;
        Proxy p = proxies.get(0);
        if (Proxy.Type.DIRECT == p.type()) {
            return null;
        }
        if (p.address() instanceof InetSocketAddress) {
            return (InetSocketAddress)p.address();
        }
        LOGGER.log(Level.INFO, p.address() + " is not instanceof InetSocketAddress but " + p.address().getClass());
        return null;
    }
}

